﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace wol
{
    public class Property : OwlObject
    {

		public const string OwlFunctionalPropertyType = "&owl;FunctionalProperty";
		public const string RdfsDomain = "domain";
		public const string RdfsRange = "range";
		public const string RdfsSubPropertyOf = "subPropertyOf";

        // rdf:resource attribute of rdfs:domain element
        // or
        // owl:Class element in rdfs:domain element
        OwlClass Domain { get; set; }

        // "&owl;FunctionalProperty" value of rdf:resource attribute of rdf:type element
        bool? Functional { get; set; }

        protected override bool DeserializeInner(XElement source)
        {
            bool result = base.DeserializeInner(source);
            if (XmlHelp.ElementIs(source, OwlModel.RdfsSpace, RdfsDomain))
            {
                Domain = GetClassSpecification(source);
                result = true;
            }
            else
            {
                if (XmlHelp.ElementIs(source, OwlModel.RdfSpace, RdfType))
                {
					XAttribute resourceAttribute = XmlHelp.AttributeOf(source, OwlModel.RdfSpace, RdfResource);
					if ((null != resourceAttribute) && (resourceAttribute.Value == OwlFunctionalPropertyType))
					{
						Functional = true;
					}
                    result = true;
                }
            }
            return result;
        }

        public override string Display
        {
            get
            {
                string result = "Property " + base.Display;
                if (null != Domain)
                {
                    result += System.Environment.NewLine + "\tdomain:" + Domain.Display;
                }
                if (null != Functional)
                {
                    result += System.Environment.NewLine + "\tFunctional=" + ((bool)Functional).ToString();
                }
                return result;
            }
        }

		protected OwlClass GetClassSpecification(XElement source)
		{
			OwlClass result = null;
			XAttribute resourceAttribute = XmlHelp.AttributeOf(source, OwlModel.RdfSpace, RdfResource);
			if (null == resourceAttribute)
			{
				foreach (System.Xml.Linq.XElement element in source.Elements())
				{
					if (XmlHelp.ElementIs(element, OwlModel.OwlSpace, OwlClass))
					{
						if (null != InModel)
						{
							result = InModel.MakeAnonymousClass();
							result.Deserialize(element);
						}
					}
				}
			}
			else
			{
				string normalName = OwlNameInSpace.NormalizeName(resourceAttribute.Value, InModel);
				result = FindOrMakeClass(normalName);
			}
			return result;
		}

		protected OwlClass FindOrMakeClass(string name)
		{
			OwlClass result = null;
			if (null != InModel)
			{
				result = InModel.FindOrMakeClass(name);
			}
			return result;
		}

    }
}
