﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace wol
{
	public class OwlIndividual : OwlObject
	{

		public List<OwlClass> MemberOf { get; set; }

		public string Syntax { get; set; }

		protected override bool DeserializeInner(XElement source)
		{
			bool result = base.DeserializeInner(source);
			if (!result)
			{
				if (XmlHelp.ElementIs(source, OwlModel.RdfSpace, RdfType))
				{
					XAttribute resourceAttribute = XmlHelp.AttributeOf(source, OwlModel.RdfSpace, RdfResource);
					if ((null != resourceAttribute) && (null != InModel))
					{
						string normalName = OwlNameInSpace.NormalizeName(resourceAttribute.Value, InModel);
						if (false == normalName.EndsWith(OwlNameInSpace.NamespaceRightBracket + "Thing"))
						{
							if (null == MemberOf)
							{
								MemberOf = new List<OwlClass>();
							}
							MemberOf.Add(InModel.FindOrMakeClass(normalName));
							result = true;
						}
					}
				} else
				{
					if (XmlHelp.ElementIs(source, "syntax"))
					{
						Syntax = source.Value;
					}
				}
			}
			return result;
		}

		public override string Display
		{
			get
			{
				string result = "Individual " + base.Display;
				if (null != MemberOf)
				{
					foreach (OwlClass classification in MemberOf)
					{
						result += System.Environment.NewLine + "\t" + RdfType + ":";
						if (false == classification.Anonymous)
						{
							result += System.Environment.NewLine + "\t";
						}
						result += classification.DisplayNameOrAll;
					}
				}
				return result;
			}
		}

		protected override void ChangedName(string oldName)
		{
			InModel.IndividualChangedName(oldName, this);
		}

	}
}
