﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace wol
{
    public class OwlClass : OwlObject
    {

		public const string OwlAllValuesFrom = "allValuesFrom";
		public const string OwlCardinality = "cardinality";
		public const string OwlDisjointWith = "disjointWith";
		public const string OwlEquivalentClass = "equivalentClass";
		public const string OwlIntersectionOf = "intersectionOf";
		public const string OwlMaxQualifiedCardinality = "maxQualifiedCardinality";
		public const string OwlMinQualifiedCardinality = "minQualifiedCardinality";
		public const string OwlOnClass = "onClass";
		public const string OwlOnDataRange = "onDataRange";
		public const string OwlOneOf = "oneOf";
		public const string OwlOnProperty = "onProperty";
		public const string OwlHasValue = "hasValue";
		public const string OwlQualifiedCardinality = "qualifiedCardinality";
		public const string OwlSomeValuesFrom = "someValuesFrom";
		public const string OwlUnionOf = "unionOf";
		public const string RdfDatatype = "datatype";
		public const string RdfDescription = "Description";
		public const string RdfParseType = "parseType";
		public const string RdfParseTypeCollection = "Collection";
		public const string RdfsSubClassOf = "subClassOf";
		public const string XsdNonNegativeInteger = "nonNegativeInteger";

        // rdf:resource attribute of rdfs:subClassOf element in owl:Class element
        // rdf:resource may be #reference or &owl;reference
        public List<OwlClass> SubclassOf { get; set; }

        // owl:equivalentClass element
        public List<OwlClass> EquivalentClass { get; set; }

        // list is owl:unionOf element with attribute rdf:parseType="Collection"
        // items in list may be
        //   rdf:about attribute of rdf:Description element
        //   owl:Restriction element
        public List<OwlClass> UnionOf { get; set; }

        // list is owl:intersectionOf element with attribute rdf:parseType="Collection"
        // items in list may be
        //   rdf:about attribute of rdf:Description element
        //   owl:Restriction element
        public List<OwlClass> IntersectionOf { get; set; }

        // rdf:resource attribute of owl:onProperty element in owl:Restriction element
        public Property RestrictProperty { get; set; }

        // rdf:resource attribute of owl:onClass element in owl:Restriction element
        public OwlClass RestrictClass { get; set; }

        // rdf:resource attribute of owl:onDataRange element in owl:Restriction element
        public Datatype RestrictDataRange { get; set; }

        // owl:qualifiedCardinality element with rdf:datatype="&xsd;nonNegativeInteger" in owl:Restriction element
        public uint? QualifiedCardinality { get; set; }

        // owl:maxQualifiedCardinality element with rdf:datatype="&xsd;nonNegativeInteger" in owl:Restriction element
        public uint? MaximumQualifiedCardinality { get; set; }

		public uint? MinimumQualifiedCardinality { get; set; }

		public uint? Cardinality { get; set; }

		// value of owl:hasValue element in owl:Restriction element
		public string HasValue { get; set; }

        // rdf:resource attribute of owl:someValuesFrom element in owl:Restriction element
        public OwlClass SomeValuesFrom { get; set; }

        // rdf:resource attribute of owl:allValuesFrom element in owl:Restriction element
        public OwlClass AllValuesFrom { get; set; }

		public List<OwlIndividual> OneOf { get; set; }

		public List<OwlClass> DisjointWith { get; set; }

		/// <summary>
		/// This getter returns the super class of this class, or null if none such.
		/// </summary>
		public OwlClass SuperClass
		{
			get
			{
				OwlClass superClass = null;
				if ((null != SubclassOf) && (0 < SubclassOf.Count))
				{
					superClass = SubclassOf[0];
				}
				return superClass;
			}
		}

		/// <summary>
		/// For an anonymous equivalent class definition, this getter returns a related class.
		/// </summary>
		public OwlClass RelatedClass
		{
			get
			{
				OwlClass related = RestrictClass;
				if (null == related)
				{
					related = SomeValuesFrom;
				}
				if (null == related)
				{
					related = AllValuesFrom;
				}
				return related;
			}
		}

		protected override bool DeserializeInner(XElement source)
		{
			bool result = base.DeserializeInner(source);
			if (!result)
			{
				if (XmlHelp.ElementIs(source, OwlModel.RdfsSpace, RdfsSubClassOf))
				{
					XAttribute resourceAttribute = XmlHelp.AttributeOf(source, OwlModel.RdfSpace, RdfResource);
					if ((null != resourceAttribute) && (null != InModel))
					{
						string normalName = OwlNameInSpace.NormalizeName(resourceAttribute.Value, InModel);
						OwlClass baseClass = InModel.FindOrMakeClass(normalName);
						if (null == SubclassOf)
						{
							SubclassOf = new List<OwlClass>();
						}
						SubclassOf.Add(baseClass);
						result = true;
					}
				}
				else
				{
					if (XmlHelp.ElementIs(source, OwlModel.OwlSpace, OwlEquivalentClass))
					{
						if (null != InModel)
						{
							OwlClass equivalent = InModel.MakeAnonymousClass();
							foreach (System.Xml.Linq.XElement item in source.Elements())
							{
								equivalent.Deserialize(item);
							}
							if (null == EquivalentClass)
							{
								EquivalentClass = new List<OwlClass>();
							}
							EquivalentClass.Add(equivalent);
							result = true;
						}
					}
					else
					{
						if (XmlHelp.ElementIs(source, OwlModel.OwlSpace, OwlUnionOf))
						{
							XAttribute parseTypeAttribute = XmlHelp.AttributeOf(source, OwlModel.RdfSpace, RdfParseType);
							if ((null != parseTypeAttribute) && (parseTypeAttribute.Value == RdfParseTypeCollection) && (null != InModel))
							{
								foreach (XElement unionElement in source.Elements())
								{
									OwlClass unioned = null;
									if (XmlHelp.ElementIs(unionElement, OwlModel.RdfSpace, RdfDescription))
									{
										XAttribute aboutAttribute = XmlHelp.AttributeOf(unionElement, OwlModel.RdfSpace, RdfAbout);
										if (null == aboutAttribute)
										{
											unioned = InModel.MakeAnonymousClass();
										}
										else
										{
											string normalName = OwlNameInSpace.NormalizeName(aboutAttribute.Value, InModel);
											unioned = InModel.FindOrMakeClass(normalName);
										}
									}
									else
									{
										unioned = InModel.MakeAnonymousClass();
									}
									unioned.Deserialize(unionElement);
									if (null == UnionOf)
									{
										UnionOf = new List<OwlClass>();
									}
									UnionOf.Add(unioned);
									result = true;
								}
							}
						}
						else
						{
							if (XmlHelp.ElementIs(source, OwlModel.OwlSpace, OwlIntersectionOf))
							{
								XAttribute parseTypeAttribute = XmlHelp.AttributeOf(source, OwlModel.RdfSpace, RdfParseType);
								if ((null != parseTypeAttribute) && (parseTypeAttribute.Value == RdfParseTypeCollection) && (null != InModel))
								{
									foreach (XElement intersectionElement in source.Elements())
									{
										OwlClass intersectioned = null;
										if (XmlHelp.ElementIs(intersectionElement, OwlModel.RdfSpace, RdfDescription))
										{
											XAttribute aboutAttribute = XmlHelp.AttributeOf(intersectionElement, OwlModel.RdfSpace, RdfAbout);
											if (null == aboutAttribute)
											{
												intersectioned = InModel.MakeAnonymousClass();
											}
											else
											{
												string normalName = OwlNameInSpace.NormalizeName(aboutAttribute.Value, InModel);
												intersectioned = InModel.FindOrMakeClass(normalName);
											}
										}
										else
										{
											intersectioned = InModel.MakeAnonymousClass();
										}
										intersectioned.Deserialize(intersectionElement);
										if (null == IntersectionOf)
										{
											IntersectionOf = new List<OwlClass>();
										}
										IntersectionOf.Add(intersectioned);
										result = true;
									}
								}
							}
							else
							{
								if (XmlHelp.ElementIs(source, OwlModel.OwlSpace, OwlOnProperty))
								{
									XAttribute resourceAttribute = XmlHelp.AttributeOf(source, OwlModel.RdfSpace, RdfResource);
									if ((null != resourceAttribute) && (null != InModel))
									{
										Property property = InModel.FindOrMakeProperty(resourceAttribute.Value);
										RestrictProperty = property;
										result = true;
									}
								}
								else
								{
									if (XmlHelp.ElementIs(source, OwlModel.OwlSpace, OwlOnClass))
									{
										XAttribute resourceAttribute = XmlHelp.AttributeOf(source, OwlModel.RdfSpace, RdfResource);
										if ((null != resourceAttribute) && (null != InModel))
										{
											OwlClass owlClass = InModel.FindOrMakeClass(resourceAttribute.Value);
											RestrictClass = owlClass;
											result = true;
										}
									}
									else
									{
										if (XmlHelp.ElementIs(source, OwlModel.OwlSpace, OwlOnDataRange))
										{
											XAttribute resourceAttribute = XmlHelp.AttributeOf(source, OwlModel.RdfSpace, RdfResource);
											if ((null != resourceAttribute) && (null != InModel))
											{
												string normalName = OwlNameInSpace.NormalizeName(resourceAttribute.Value, InModel);
												Datatype datatype = InModel.FindOrMakeDatatype(normalName);
												RestrictDataRange = datatype;
												result = true;
											}
										}
										else
										{
											if (XmlHelp.ElementIs(source, OwlModel.OwlSpace, OwlQualifiedCardinality))
											{
												XAttribute datatypeAttribute = XmlHelp.AttributeOf(source, OwlModel.RdfSpace, RdfDatatype);
												if ((null != datatypeAttribute) && (datatypeAttribute.Value ==
													(OwlModel.XsdSpace + XsdNonNegativeInteger)))
												{
													uint cardinality = uint.Parse(source.Value);
													QualifiedCardinality = cardinality;
													result = true;
												}
											}
											else
											{
												if (XmlHelp.ElementIs(source, OwlModel.OwlSpace, OwlMaxQualifiedCardinality))
												{
													XAttribute datatypeAttribute = XmlHelp.AttributeOf(source, OwlModel.RdfSpace, RdfDatatype);
													if ((null != datatypeAttribute) && (datatypeAttribute.Value ==
														(OwlModel.XsdSpace + XsdNonNegativeInteger)))
													{
														uint cardinality = uint.Parse(source.Value);
														MaximumQualifiedCardinality = cardinality;
														result = true;
													}
												}
												else
												{
													if (XmlHelp.ElementIs(source, OwlModel.OwlSpace, OwlMinQualifiedCardinality))
													{
														XAttribute datatypeAttribute = XmlHelp.AttributeOf(source, OwlModel.RdfSpace, RdfDatatype);
														if ((null != datatypeAttribute) && (datatypeAttribute.Value == (OwlModel.XsdSpace + XsdNonNegativeInteger)))
														{
															uint cardinality = uint.Parse(source.Value);
															MinimumQualifiedCardinality = cardinality;
															result = true;
														}
													}
													else
													{
														if (XmlHelp.ElementIs(source, OwlModel.OwlSpace, OwlSomeValuesFrom))
														{
															XAttribute resourceAttribute =
																XmlHelp.AttributeOf(source, OwlModel.RdfSpace, RdfResource);
															if ((null != resourceAttribute) && (null != InModel))
															{
																OwlClass owlClass = InModel.FindOrMakeClass(resourceAttribute.Value);
																SomeValuesFrom = owlClass;
																result = true;
															}
														}
														else
														{
															if (XmlHelp.ElementIs(source, OwlModel.OwlSpace, OwlAllValuesFrom))
															{
																XAttribute resourceAttribute =
																	XmlHelp.AttributeOf(source, OwlModel.RdfSpace, RdfResource);
																if ((null != resourceAttribute) && (null != InModel))
																{
																	OwlClass owlClass = InModel.FindOrMakeClass(resourceAttribute.Value);
																	AllValuesFrom = owlClass;
																	result = true;
																}
															}
															else
															{
																if (XmlHelp.ElementIs(source, OwlModel.OwlSpace, OwlHasValue))
																{
																	HasValue = source.Value;
																	result = true;
																}
																else
																{
																	if (XmlHelp.ElementIs(source, OwlModel.OwlSpace, OwlOneOf))
																	{
																		XAttribute parseTypeAttribute =
																			XmlHelp.AttributeOf(source, OwlModel.RdfSpace, RdfParseType);
																		if ((null != parseTypeAttribute) && (parseTypeAttribute.Value ==
																			RdfParseTypeCollection) && (null != InModel))
																		{
																			foreach (XElement choiceElement in source.Elements())
																			{
																				OwlIndividual choice = null;
																				if (XmlHelp.ElementIs(choiceElement, OwlModel.RdfSpace, RdfDescription))
																				{
																					XAttribute aboutAttribute =
																						XmlHelp.AttributeOf(choiceElement, OwlModel.RdfSpace, RdfAbout);
																					if (null == aboutAttribute)
																					{
																						choice = InModel.MakeAnonymousIndividual();
																					}
																					else
																					{
																						string normalName =
																							OwlNameInSpace.NormalizeName(aboutAttribute.Value, InModel);
																						choice = InModel.FindOrMakeIndividual(normalName);
																					}
																				}
																				else
																				{
																					choice = InModel.MakeAnonymousIndividual();
																				}
																				choice.Deserialize(choiceElement);
																				if (null == OneOf)
																				{
																					OneOf = new List<OwlIndividual>();
																				}
																				OneOf.Add(choice);
																				result = true;
																			}
																		}
																	}
																	else
																	{
																		if (XmlHelp.ElementIs(source, OwlModel.OwlSpace, OwlCardinality))
																		{
																			XAttribute datatypeAttribute =
																				XmlHelp.AttributeOf(source, OwlModel.RdfSpace, RdfDatatype);
																			if ((null != datatypeAttribute) && (datatypeAttribute.Value == (OwlModel.XsdSpace + XsdNonNegativeInteger)))
																			{
																				uint cardinality = uint.Parse(source.Value);
																				Cardinality = cardinality;
																				result = true;
																			}
																		}
																		else
																		{
																			if (XmlHelp.ElementIs(source, OwlModel.OwlSpace, OwlDisjointWith))
																			{
																				XAttribute resourceAttribute =
																					XmlHelp.AttributeOf(source, OwlModel.RdfSpace, RdfResource);
																				if ((null != resourceAttribute) && (null != InModel))
																				{
																					string normalName =
																						OwlNameInSpace.NormalizeName(resourceAttribute.Value, InModel);
																					OwlClass disjointClass = InModel.FindOrMakeClass(normalName);
																					if (null == DisjointWith)
																					{
																						DisjointWith = new List<OwlClass>();
																					}
																					DisjointWith.Add(disjointClass);
																					result = true;
																				}
																			}
																			else
																			{
																				throw new Exception("unsupported class specification " + source.ToString(System.Xml.Linq.SaveOptions.None) + ".");
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			return result;
		}

        public override string Display
        {
            get
            {
                string result = "Class " + base.Display;
                if (null != SubclassOf)
                {
                    result += System.Environment.NewLine + "\t" + RdfsSubClassOf + "(";
					if (1 >= SubclassOf.Count)
					{
						foreach (OwlClass item in SubclassOf)
						{
                            result += item.DisplayName;
						}
						result += ")";
					}
					else
					{
						foreach (OwlClass item in SubclassOf)
						{
							result += System.Environment.NewLine + "\t" + item.DisplayName;
						}
						result += System.Environment.NewLine + "\t)";
					}
                }
                if (null != EquivalentClass)
                {
					result += System.Environment.NewLine + "\t" + OwlEquivalentClass + ":";
					foreach (OwlClass item in EquivalentClass)
					{
						if (false == item.Anonymous)
						{
							result += System.Environment.NewLine + "\t";
						}
						result += item.Display;
					}
                }
                if (null != UnionOf)
                {
                    result += System.Environment.NewLine + "\t" + OwlUnionOf + "(";
                    foreach (OwlClass item in UnionOf)
                    {
                        result += System.Environment.NewLine + "\t" + item.DisplayNameOrAll;
                    }
                    result += System.Environment.NewLine + "\t)";
                }
                if (null != IntersectionOf)
                {
                    result += System.Environment.NewLine + "\t" + OwlIntersectionOf + "(";
                    foreach (OwlClass item in IntersectionOf)
                    {
                        result += System.Environment.NewLine + "\t" + item.DisplayNameOrAll;
                    }
                    result += System.Environment.NewLine + "\t)";
                }
				if (null != RestrictProperty)
				{
					result += System.Environment.NewLine + "\t" + OwlOnProperty + ":" + RestrictProperty.DisplayName;
				}
				if (null != RestrictClass)
				{
					result += System.Environment.NewLine + "\t" + OwlOnClass + ":" + RestrictClass.DisplayName;
				}
				if (null != RestrictDataRange)
				{
					result += System.Environment.NewLine + "\t" + OwlOnDataRange + ":" + RestrictDataRange.DisplayName;
				}
				if (null != QualifiedCardinality)
				{
					result += System.Environment.NewLine + "\t" + OwlQualifiedCardinality + ":" + ((uint)QualifiedCardinality).ToString();
				}
				if (null != MaximumQualifiedCardinality)
				{
					result += System.Environment.NewLine + "\t" + OwlMaxQualifiedCardinality + ":" + ((uint)MaximumQualifiedCardinality).ToString();
				}
				if (null != MinimumQualifiedCardinality)
				{
					result += System.Environment.NewLine + "\t" + OwlMinQualifiedCardinality + ":" + ((uint)MinimumQualifiedCardinality).ToString();
				}
				if (null != SomeValuesFrom)
				{
					result += System.Environment.NewLine + "\t" + OwlSomeValuesFrom + ":" + SomeValuesFrom.DisplayName;
				}
				if (null != AllValuesFrom)
				{
					result += System.Environment.NewLine + "\t" + OwlAllValuesFrom + ":" + AllValuesFrom.DisplayName;
				}
				if (null != OneOf)
				{
					result += System.Environment.NewLine + "\t" + OwlOneOf + "(";
					foreach (OwlIndividual item in OneOf)
					{
						result += System.Environment.NewLine + "\t" + item.DisplayNameOrAll;
					}
					result += System.Environment.NewLine + "\t)";
				}
				if (null != Cardinality)
				{
					result += System.Environment.NewLine + "\t" + OwlCardinality + ":" + ((uint)Cardinality).ToString();
				}
				if (null != DisjointWith)
				{
					result += System.Environment.NewLine + "\t" + OwlDisjointWith + "(";
					foreach (OwlClass item in DisjointWith)
					{
						result += System.Environment.NewLine + "\t" + item.DisplayNameOrAll;
					}
					result += System.Environment.NewLine + "\t)";
				}
				return result;
            }
        }

		protected override void ChangedName(string oldName)
		{
			InModel.ClassChangedName(oldName, this);
		}

    }
}
