﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace wol
{
    public class DatatypeProperty : Property
    {

		// rdf:resource attribute of rdfs:subPropertyOf element in owl:DatatypeProperty element
		public DatatypeProperty SubpropertyOf { get; set; }

        // rdf:resource attribute of rdfs:range element
        // or
        // owl:Class element in rdfs:range element
        Datatype Range { get; set; }

		protected override bool DeserializeInner(System.Xml.Linq.XElement source)
		{
			bool result = base.DeserializeInner(source);
			if (XmlHelp.ElementIs(source, OwlModel.RdfsSpace, RdfsRange))
			{
				Range = GetDatatypeSpecification(source);
				result = true;
			}
			else
			{
				if (XmlHelp.ElementIs(source, OwlModel.RdfsSpace, RdfsSubPropertyOf))
				{
					SubpropertyOf = GetSubpropertySpecification(source);
					result = true;
				}
			}
			return result;
		}

		public override string Display
		{
			get
			{
				string result = "Datatype" + base.Display;
				if (null != Range)
				{
					result += System.Environment.NewLine + "\trange:" + Range.Display;
				}
				if (null != SubpropertyOf)
				{
					result += System.Environment.NewLine + "\tsubpropertyOf:" + SubpropertyOf.Display;
				}
				return result;
			}
		}

		protected Datatype GetDatatypeSpecification(XElement source)
		{
			Datatype result = null;
			XAttribute resourceAttribute = XmlHelp.AttributeOf(source, OwlModel.RdfSpace, "resource");
			if (null != resourceAttribute)
			{
				result = FindOrMakeDatatype(resourceAttribute.Value);
			}
			return result;
		}

		protected Datatype FindOrMakeDatatype(string name)
		{
			Datatype result = null;
			if (null != InModel)
			{
				result = InModel.FindOrMakeDatatype(name);
			}
			return result;
		}

		protected DatatypeProperty GetSubpropertySpecification(XElement source)
		{
			DatatypeProperty result = null;
			XAttribute resourceAttribute = XmlHelp.AttributeOf(source, OwlModel.RdfSpace, "resource");
			if (null != resourceAttribute)
			{
				result = FindOrMakeDatatypeProperty(resourceAttribute.Value);
			}
			return result;
		}

		protected DatatypeProperty FindOrMakeDatatypeProperty(string name)
		{
			DatatypeProperty result = null;
			if (null != InModel)
			{
				result = InModel.FindOrMakeDatatypeProperty(name);
			}
			return result;
		}

		protected override void ChangedName(string oldName)
		{
			InModel.DatatypePropertyChangedName(oldName, this);
		}

    }
}
